/*
 * Decompiled with CFR 0.152.
 */
package whaleluckyblock.entity;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import whaleluckyblock.entity.EntityKrakenSquid;

public class EntityColosalGuardian
extends EntityGuardian {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(EntityColosalGuardian.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityColosalGuardian.class, (DataSerializer)DataSerializers.field_187192_b);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    protected float field_175482_b;
    protected float field_175484_c;
    protected float field_175483_bk;
    protected float field_175485_bl;
    protected float field_175486_bm;
    private EntityLivingBase targetedEntity;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    protected EntityAIWander field_175481_bq;

    public EntityColosalGuardian(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.func_70105_a(5.85f, 5.85f);
        this.field_70765_h = new GuardianMoveHelper(this);
        this.field_175484_c = this.field_175482_b = this.field_70146_Z.nextFloat();
    }

    protected void func_184651_r() {
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.field_175481_bq = new EntityAIWander((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIGuardianAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.field_175481_bq);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityColosalGuardian.class, 12.0f, 0.01f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_175481_bq.func_75248_a(3);
        entityaimovetowardsrestriction.func_75248_a(3);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new GuardianTargetSelector(this)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
    }

    public static void registerFixesGuardian(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityColosalGuardian.class);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    public boolean func_175472_n() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    private void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    public int func_175464_ck() {
        return 80;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean func_175474_cn() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    @Nullable
    public EntityLivingBase func_175466_co() {
        if (!this.func_175474_cn()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public int func_70627_aG() {
        return 160;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? SoundEvents.field_187670_cb : SoundEvents.field_187672_cc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_70090_H() ? SoundEvents.field_187687_ch : SoundEvents.field_187690_ci;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_70090_H() ? SoundEvents.field_187678_ce : SoundEvents.field_187681_cf;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public void func_70636_d() {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.field_70170_p.field_72995_K) {
            this.field_175484_c = this.field_175482_b;
            if (!this.func_70090_H()) {
                this.field_175483_bk = 2.0f;
                if (this.field_70181_x > 0.0 && this.clientSideTouchedGround && !this.func_174814_R()) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_190765_dj(), this.func_184176_by(), 1.0f, 1.0f, false);
                }
                this.clientSideTouchedGround = this.field_70181_x < 0.0 && this.field_70170_p.func_175677_d(new BlockPos((Entity)this).func_177977_b(), false);
            } else {
                this.field_175483_bk = this.func_175472_n() ? (this.field_175483_bk < 0.5f ? 4.0f : (this.field_175483_bk += (0.5f - this.field_175483_bk) * 0.1f)) : (this.field_175483_bk += (0.125f - this.field_175483_bk) * 0.2f);
            }
            this.field_175482_b += this.field_175483_bk;
            this.field_175486_bm = this.field_175485_bl;
            this.field_175485_bl = !this.func_70090_H() ? this.field_70146_Z.nextFloat() : (this.func_175472_n() ? (this.field_175485_bl += (0.0f - this.field_175485_bl) * 0.25f) : (this.field_175485_bl += (1.0f - this.field_175485_bl) * 0.06f));
            if (this.func_175472_n() && this.func_70090_H()) {
                Vec3d vec3d = this.func_70676_i(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - vec3d.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72449_c * 1.5, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (this.func_175474_cn()) {
                EntityLivingBase entitylivingbase;
                if (this.clientSideAttackTime < this.func_175464_ck()) {
                    ++this.clientSideAttackTime;
                }
                if ((entitylivingbase = this.func_175466_co()) != null) {
                    this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
                    this.func_70671_ap().func_75649_a();
                    double d5 = this.func_175477_p(0.0f);
                    double d0 = entitylivingbase.field_70165_t - this.field_70165_t;
                    double d1 = entitylivingbase.field_70163_u + (double)(entitylivingbase.field_70131_O * 0.5f) - (this.field_70163_u + (double)this.func_70047_e());
                    double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_70146_Z.nextDouble();
                    while (d4 < d3) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.5;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70122_E = false;
            this.field_70160_al = true;
        }
        if (this.func_175474_cn()) {
            this.field_70177_z = this.field_70759_as;
        }
        super.func_70636_d();
    }

    protected SoundEvent func_190765_dj() {
        return SoundEvents.field_187684_cg;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175471_a(float p_175471_1_) {
        return this.field_175484_c + (this.field_175482_b - this.field_175484_c) * p_175471_1_;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return cls == EntityKrakenSquid.class ? false : super.func_70686_a(cls);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175469_o(float p_175469_1_) {
        return this.field_175486_bm + (this.field_175485_bl - this.field_175486_bm) * p_175469_1_;
    }

    public float func_175477_p(float p_175477_1_) {
        return ((float)this.clientSideAttackTime + p_175477_1_) / (float)this.func_175464_ck();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186440_v;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean func_70601_bi() {
        return (this.field_70146_Z.nextInt(20) == 0 || !this.field_70170_p.func_175710_j(new BlockPos((Entity)this))) && super.func_70601_bi();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_175472_n() && !source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), entitylivingbase.func_110138_aP() * 2.0f);
            }
        }
        if (this.field_175481_bq != null) {
            this.field_175481_bq.func_179480_f();
        }
        return super.func_70097_a(source, amount);
    }

    public int func_70646_bf() {
        return 180;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (!this.func_175472_n() && this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    static class GuardianTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityColosalGuardian parentEntity;

        public GuardianTargetSelector(EntityColosalGuardian guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable EntityLivingBase p_apply_1_) {
            return (p_apply_1_ instanceof EntityPlayer || p_apply_1_ instanceof EntitySquid || p_apply_1_ instanceof EntityIronGolem || p_apply_1_ instanceof EntityTameable) && p_apply_1_.func_70068_e((Entity)this.parentEntity) > 9.0;
        }
    }

    static class GuardianMoveHelper
    extends EntityMoveHelper {
        private final EntityColosalGuardian entityGuardian;

        public GuardianMoveHelper(EntityColosalGuardian guardian) {
            super((EntityLiving)guardian);
            this.entityGuardian = guardian;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.entityGuardian.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.entityGuardian.field_70165_t;
                double d1 = this.field_75647_c - this.entityGuardian.field_70163_u;
                double d2 = this.field_75644_d - this.entityGuardian.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.func_75639_a(this.entityGuardian.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityGuardian.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityGuardian.func_70659_e(this.entityGuardian.func_70689_ay() + (f1 - this.entityGuardian.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.entityGuardian.field_70177_z * ((float)Math.PI / 180));
                this.entityGuardian.field_70159_w += d4 * d5;
                this.entityGuardian.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.75) * 0.05;
                this.entityGuardian.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityGuardian.field_70181_x += (double)this.entityGuardian.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entityGuardian.func_70671_ap();
                double d7 = this.entityGuardian.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityGuardian.func_70047_e() + this.entityGuardian.field_70163_u + d1 / d3;
                double d9 = this.entityGuardian.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityGuardian.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entityGuardian.setMoving(true);
            } else {
                this.entityGuardian.func_70659_e(0.0f);
                this.entityGuardian.setMoving(false);
            }
        }
    }

    static class AIGuardianAttack
    extends EntityAIBase {
        private final EntityColosalGuardian guardian;
        private int tickCounter;

        public AIGuardianAttack(EntityColosalGuardian guardian) {
            this.guardian = guardian;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.guardian.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.guardian.func_70068_e((Entity)this.guardian.func_70638_az()) > 9.0;
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)this.guardian.func_70638_az(), 90.0f, 90.0f);
            this.guardian.field_70160_al = true;
        }

        public void func_75251_c() {
            this.guardian.setTargetedEntity(0);
            this.guardian.func_70624_b(null);
            this.guardian.field_175481_bq.func_179480_f();
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.guardian.func_70638_az();
            this.guardian.func_70661_as().func_75499_g();
            this.guardian.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
            if (!this.guardian.func_70685_l((Entity)entitylivingbase)) {
                this.guardian.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.guardian.setTargetedEntity(this.guardian.func_70638_az().func_145782_y());
                    this.guardian.field_70170_p.func_72960_a((Entity)this.guardian, (byte)21);
                } else if (this.tickCounter >= this.guardian.func_175464_ck()) {
                    float f = 1.0f;
                    if (this.guardian.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        f += 200.0f;
                    }
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)this.guardian, (Entity)this.guardian), f);
                    entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.guardian), (float)this.guardian.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.guardian.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }
}

