/*
 * Decompiled with CFR 0.152.
 */
package whaleluckyblock.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import whaleluckyblock.items.ModItems;

public class EntityKrakenSquid
extends EntityFlying
implements IMob {
    public int attackTimer;
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityKrakenSquid.class, (DataSerializer)DataSerializers.field_187198_h);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);

    public EntityKrakenSquid(World worldIn) {
        super(worldIn);
        this.func_70105_a(4.0f, 7.5f);
        this.field_70178_ae = true;
        this.field_70765_h = new KrakenSquidMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(800.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return cls == EntityKrakenSquid.class ? false : super.func_70686_a(cls);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public float func_70047_e() {
        return 5.75f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    public void func_70071_h_() {
        if (this.func_70089_S() && this.field_70146_Z.nextInt(30) == 0) {
            this.LightningStrike();
        }
        super.func_70071_h_();
    }

    public void LightningStrike() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(30.0, 50.0, 30.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        for (EntityLivingBase entity : entities) {
            if (entity instanceof EntityKrakenSquid || entity == this) continue;
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.field_70170_p.func_72912_H().func_176142_i(0);
        this.field_70170_p.func_72912_H().func_76080_g(1000);
        this.field_70170_p.func_72912_H().func_76090_f(1000);
        this.field_70170_p.func_72912_H().func_76084_b(true);
        this.field_70170_p.func_72912_H().func_76069_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else {
            super.func_70103_a(id);
        }
    }

    public static void registerFixesCreeper(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityKrakenSquid.class);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int i = this.field_70146_Z.nextInt(9);
        int DropChance = this.field_70146_Z.nextInt(15);
        if (!this.field_70170_p.field_72995_K) {
            this.func_145779_a(ModItems.kraken_shard, i);
        }
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private final EntityKrakenSquid parentEntity;
        public int attackTimer;

        public AIFireballAttack(EntityKrakenSquid ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 10) {
                    world.func_180498_a((EntityPlayer)null, 1015, new BlockPos((Entity)this.parentEntity), 0);
                }
                if (this.attackTimer == 20) {
                    AxisAlignedBB boundingBox = new AxisAlignedBB(this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v, this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v).func_72314_b(30.0, 60.0, 30.0);
                    List entities = world.func_72872_a(EntityLivingBase.class, boundingBox);
                    for (EntityLivingBase entity : entities) {
                        if (entity == this.parentEntity) continue;
                        world.func_72942_c((Entity)new EntityLightningBolt(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false));
                    }
                } else if (this.attackTimer > 0) {
                    --this.attackTimer;
                }
                this.parentEntity.setAttacking(this.attackTimer > 10);
            }
        }

        static class AILookAround
        extends EntityAIBase {
            private final EntityKrakenSquid parentEntity;

            public AILookAround(EntityKrakenSquid ghast) {
                this.parentEntity = ghast;
                this.func_75248_a(2);
            }

            public boolean func_75250_a() {
                return true;
            }

            public void func_75246_d() {
                if (this.parentEntity.func_70638_az() == null) {
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
                } else {
                    EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                    double d0 = 64.0;
                    if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                        double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                        double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                        this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                    }
                }
            }
        }
    }

    static class KrakenSquidMoveHelper
    extends EntityMoveHelper {
        private final EntityKrakenSquid parentEntity;
        private int courseChangeCooldown;

        public KrakenSquidMoveHelper(EntityKrakenSquid ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        if (this.parentEntity.field_70163_u < 100.0) {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                            this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                        }
                        if (this.parentEntity.field_70163_u > 100.0) {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                            this.parentEntity.field_70181_x -= d1 / d3 * 0.1;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                        }
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityKrakenSquid parentEntity;

        public AIRandomFly(EntityKrakenSquid ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }
}

