/*
 * Decompiled with CFR 0.152.
 */
package whaleluckyblock.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityReverseSquid
extends EntityFlying {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityReverseSquid(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70146_Z.setSeed(1 + this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70765_h = new KrakenSquidMoveHelper(this);
    }

    public static void registerFixesSquid(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityReverseSquid.class);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186381_af;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.field_70122_E) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                this.rotateSpeed = (double)f > 0.75 ? 1.0f : (this.rotateSpeed *= 0.8f);
            } else {
                this.tentacleAngle = 0.0f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                // empty if block
            }
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
            }
        }
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u < (double)this.field_70170_p.func_181545_F() && super.func_70601_bi();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    static class KrakenSquidMoveHelper
    extends EntityMoveHelper {
        private final EntityReverseSquid parentEntity;
        private int courseChangeCooldown;

        public KrakenSquidMoveHelper(EntityReverseSquid ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        if (this.parentEntity.field_70163_u < 100.0) {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                            this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                        }
                        if (this.parentEntity.field_70163_u > 100.0) {
                            this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                            this.parentEntity.field_70181_x -= d1 / d3 * 0.1;
                            this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                        }
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityReverseSquid parentEntity;

        public AIRandomFly(EntityReverseSquid ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }
}

