/*
 * Decompiled with CFR 0.152.
 */
package whaleluckyblock.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySquidMonster
extends EntityMob {
    public int attackTimer;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntitySquidMonster.class, (DataSerializer)DataSerializers.field_187198_h);
    private float zombieWidth = -1.0f;
    private float zombieHeight = -1.2f;
    public int AbillityCooldown;

    public EntitySquidMonster(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.25f, 3.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(BABY_SPEED_BOOST);
            if (childZombie) {
                iattributeinstance.func_111121_a(BABY_SPEED_BOOST);
            }
        }
        this.setChildSize(childZombie);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public static void registerFixesCreeper(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySquidMonster.class);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(120.0);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
        return entitytippedarrow;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        if (livingdata == null) {
            livingdata = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance);
        }
        if (livingdata instanceof GroupData) {
            GroupData EntityHalfZombie$groupdata = (GroupData)livingdata;
            if (EntityHalfZombie$groupdata.isChild) {
                this.setChild(true);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = (EntityChicken)list.get(0);
                        entitychicken.func_152117_i(true);
                        this.func_184220_m((Entity)entitychicken);
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    EntityChicken entitychicken1 = new EntityChicken(this.field_70170_p);
                    entitychicken1.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    entitychicken1.func_180482_a(difficulty, (IEntityLivingData)null);
                    entitychicken1.func_152117_i(true);
                    this.field_70170_p.func_72838_d((Entity)entitychicken1);
                    this.func_184220_m((Entity)entitychicken1);
                }
            }
        }
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return livingdata;
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild;

        private GroupData(boolean p_i47328_2_) {
            this.isChild = p_i47328_2_;
        }
    }
}

