/*
 * Decompiled with CFR 0.152.
 */
package rolikdev.mobarmormod.init;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;
import rolikdev.mobarmormod.ArmorInit;

public class IEnderArmor
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorInit.ENDERMAN, (Object)new MobEffectInstance(MobEffects.f_19611_, 5000, 2)).build();

    public IEnderArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.m_5776_() && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
            player.m_147207_(new MobEffectInstance(MobEffects.f_19616_, 600, 4), (Entity)player);
            if (player.m_20069_()) {
                this.teleport(player, level);
                player.m_6469_(player.m_269291_().m_269063_(), 2.0f);
            }
            if (player.m_20096_() && player.m_6144_()) {
                this.teleport(player, level);
            }
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)"Enderman Armor"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Armor Value: 35"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Ability 1: Nightvision"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Ability 2: Teleport randomly on shift click"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Weakness: Water will damage you x2."));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    protected boolean teleport(Player player, Level level) {
        if (!player.m_9236_().m_5776_() && player.m_6084_()) {
            double d0 = player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 64.0;
            double d1 = player.m_20186_() + (double)(level.f_46441_.m_188503_(64) - 32);
            double d2 = player.m_20189_() + (double)(level.f_46441_.m_188503_(64) - 32);
            return this.teleport(player, level, d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(Player player, Level level, double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > player.m_9236_().m_141937_() && !player.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = player.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)player, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = player.m_20182_();
            boolean flag2 = player.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                player.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)player));
                if (!player.m_20067_()) {
                    player.m_9236_().m_6263_((Player)null, player.f_19854_, player.f_19855_, player.f_19856_, SoundEvents.f_11852_, player.m_5720_(), 1.0f, 1.0f);
                    player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapEffect = entry.getValue();
            if (!this.hasPlayerCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addEffectToPlayer(player, mapEffect);
        }
    }

    private void addEffectToPlayer(Player player, MobEffectInstance mapEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapEffect.m_19544_());
        if (!hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapEffect.m_19544_(), mapEffect.m_19557_(), mapEffect.m_19564_()));
        }
    }

    private boolean hasPlayerCorrectArmorOn(ArmorMaterial mapArmorMaterial, Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem chestplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return boots.m_40401_() == mapArmorMaterial && leggings.m_40401_() == mapArmorMaterial && chestplate.m_40401_() == mapArmorMaterial && helmet.m_40401_() == mapArmorMaterial;
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !boots.m_41619_() && !leggings.m_41619_() && !chestplate.m_41619_() && !helmet.m_41619_();
    }
}

