/*
 * Decompiled with CFR 0.152.
 */
package rolikdev.mobarmormod.init;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import rolikdev.mobarmormod.ArmorInit;

public class IZombieArmor
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorInit.ZOMBIE, (Object)new MobEffectInstance(MobEffects.f_19611_, 5000, 2)).build();

    public IZombieArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.m_5776_() && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
            if (player.m_21023_(MobEffects.f_19614_)) {
                player.m_21195_(MobEffects.f_19614_);
            }
            if (player.m_21023_(MobEffects.f_19612_)) {
                player.m_21195_(MobEffects.f_19612_);
            }
        }
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapEffect = entry.getValue();
            if (!this.hasPlayerCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addEffectToPlayer(player, mapEffect);
        }
    }

    private void addEffectToPlayer(Player player, MobEffectInstance mapEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapEffect.m_19544_());
        if (!hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapEffect.m_19544_(), mapEffect.m_19557_(), mapEffect.m_19564_()));
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)"Zombie Armor"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Armor Value: 26"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Ability 1: Nightvision"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Poison Resistance"));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Hunger Resistance"));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private boolean hasPlayerCorrectArmorOn(ArmorMaterial mapArmorMaterial, Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem chestplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return boots.m_40401_() == mapArmorMaterial && leggings.m_40401_() == mapArmorMaterial && chestplate.m_40401_() == mapArmorMaterial && helmet.m_40401_() == mapArmorMaterial;
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !boots.m_41619_() && !leggings.m_41619_() && !chestplate.m_41619_() && !helmet.m_41619_();
    }
}

